;initram_forcerank.asm

InitialiseGameRulesRAM_TurnTimer:
	push	{r4,r5,r14}
;Nulls the value if unset
	mov	r1,0x0	;Timer in Seconds (approx)
	ldr	r0,=CurrentGameOptions
	add	r0,GameRule_TurnTimer
	strh	r1,[r0]
	
	;Checks if the current Game Mode is Versus
	ldr	r0,=CurrentGameOptions
	add	r0,GameRule_Gamemode
	ldrb	r0,[r0]
	cmp	r0,GameMode_Versus
	bne	@End
	
	;Checks if there is at least two human players to run a turn timer
	mov	r0,0
	ldr	r1,=0x02017C50

;Checks P1	
	ldrb	r2,[r1,0x9]
	cmp	r2,0x1	;Human Control
	bne	@TimerCheck_IsHuman_P2
	
	add	r0,1
	
@TimerCheck_IsHuman_P2:
	ldrb	r2,[r1,0xA]
	cmp	r2,0x1	;Human Control
	bne	@TimerCheck_IsHuman_P3
	
	add	r0,1
	
@TimerCheck_IsHuman_P3:
	ldrb	r2,[r1,0x8]
	cmp	r2,3
	blt	@TimerCheck_HumanTally

	ldrb	r2,[r1,0xB]
	cmp	r2,0x1	;Human Control
	bne	@TimerCheck_IsHuman_P4
	
	add	r0,1

@TimerCheck_IsHuman_P4:
	ldrb	r2,[r1,0x8]
	cmp	r2,4
	blt	@TimerCheck_HumanTally

	ldrb	r2,[r1,0xB]
	cmp	r2,0x1	;Human Control
	bne	@TimerCheck_HumanTally
	
	add	r0,1

@TimerCheck_HumanTally:
	cmp	r0,2
	blt	@End
	
;Actually set the turn timer
	ldr	r1,=180	;Timer in Seconds (approx)
	ldr	r0,=CurrentGameOptions
	add	r0,GameRule_TurnTimer
	strh	r1,[r0]	
	
@End:	
	pop	{r4,r5}
	pop	{r0}
	bx	r0
	.pool
